<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');

include '../config.php'; // your DB connection file

$userid = isset($_GET['userid']) ? trim($_GET['userid']) : '';

if (empty($userid)) {
    echo json_encode([
        'status' => 'error',
        'message' => 'User ID is required',
        'data' => null
    ]);
    exit;
}

// Fetch configuration from DB
$sql = "SELECT config_json FROM setup_configurations WHERE userid = ?";
$stmt = $con->prepare($sql);
$stmt->bind_param("s", $userid);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $config = json_decode($row['config_json'], true);

    echo json_encode([
        'status' => 'success',
        'message' => 'Setup configuration retrieved successfully',
        'data' => $config
    ]);
} else {
    // Return default config if not found
    echo json_encode([
        'status' => 'success',
        'message' => 'Using default configuration',
        'data' => getDefaultConfig()
    ]);
}

$stmt->close();
$con->close();

function getDefaultConfig() {
    return [
        "printer_config" => [
            "printer_type" => "bluetooth",
            "selected_bluetooth_printer" => "",
            "paper_size" => "3-inch",
            "enabled_by_admin" => true
        ],
        "receipt_config" => [
            "receipt_type" => "retail",
            "show_qr_code" => true,
            "show_logo" => true,
            "show_scan_to_pay" => false,
            "show_feedback_qr" => true,
            "enabled_by_admin" => true
        ],
        "display_options" => [
            "show_price_range" => false,
            "show_top_sellers_option" => true,
            "show_top_sellers_badge" => true,
            "compact_mode" => false,
            "enabled_by_admin" => true
        ],
        "table_billing_config" => [
            "enable_table_billing" => true,
            "table_count" => 10,
            "enabled_by_admin" => true
        ],
        "payment_options" => [
            "show_cash_calculator" => true,
            "show_open_calculator" => false,
            "show_redeem_points" => true,
            "enable_split_payment" => false,
            "enabled_by_admin" => true
        ],
        "multi_kitchen_config" => [
            "enable_multi_kitchen_printing" => false,
            "south_indian_printer_name" => "",
            "chinese_printer_name" => "",
            "receipt_printer_name" => "",
            "south_indian_kitchen_header_name" => "SOUTH INDIAN KITCHEN",
            "chinese_kitchen_header_name" => "CHINESE KITCHEN",
            "enabled_by_admin" => true
        ],
        "advanced_features" => [
            "show_kot" => true,
            "show_online_orders_button" => true,
            "enable_crosssell_dialog" => true,
            "enabled_by_admin" => true
        ],
        "tax_config" => [
            "enable_gst" => true,
            "enabled_by_admin" => true
        ],
        "logo_config" => [
            "logo_url" => "",
            "enabled_by_admin" => true
        ],
        "section_visibility" => [
            "show_printer_configuration" => true,
            "show_receipt_configuration" => true,
            "show_logo_configuration" => true,
            "show_billing_options" => true,
            "show_multi_kitchen_printing" => true,
            "show_tax_configuration" => true
        ]
    ];
}
?>
