<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

include '../config.php'; // DB connection

$input = file_get_contents("php://input");
$data = json_decode($input, true);

if (!isset($data['userid']) || !isset($data['config'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'User ID and config are required',
        'data' => null
    ]);
    exit;
}

$userid = trim($data['userid']);
$config_json = json_encode($data['config'], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

$sql = "INSERT INTO setup_configurations (userid, config_json, updated_at)
        VALUES (?, ?, NOW())
        ON DUPLICATE KEY UPDATE 
        config_json = VALUES(config_json), 
        updated_at = VALUES(updated_at)";

$stmt = $con->prepare($sql);
$stmt->bind_param("ss", $userid, $config_json);

if ($stmt->execute()) {
    echo json_encode([
        'status' => 'success',
        'message' => 'Setup configuration updated successfully',
        'data' => [
            'updated_at' => date('c')
        ]
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to update configuration',
        'data' => null
    ]);
}

$stmt->close();
$con->close();
?>
