# Core PHP API for E-commerce App

A simple, lightweight PHP API for the Flutter e-commerce application without external dependencies.

## Features

- ✅ Products, Categories, Banners
- ✅ Shopping Cart Management
- ✅ Order Management
- ✅ Address Management
- ✅ User Authentication
- ✅ CORS Support
- ✅ JSON Responses
- ✅ Error Handling

## Setup Instructions

### 1. Upload Files

Upload all files from `api_core/` folder to:
```
https://kwickbills.com/shop/api_core/
```

### 2. Configure Database

Edit `config.php` and update database credentials:
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'ashwini_ecommerce');
define('DB_USER', 'your_username');
define('DB_PASS', 'your_password');
```

### 3. Create Database

Run this SQL command:
```sql
CREATE DATABASE ashwini_ecommerce;
```

### 4. Import Database Schema

Import the database schema:
```bash
mysql -u username -p ashwini_ecommerce < database.sql
```

Or via phpMyAdmin:
1. Select database "ashwini_ecommerce"
2. Go to Import tab
3. Choose file: `database.sql`
4. Click Go

### 5. Set Permissions

Set proper file permissions:
```bash
chmod 755 api_core/
chmod 644 api_core/*.php
chmod 644 api_core/.htaccess
```

## API Endpoints

### Products
- `GET /products.php?action=banners` - Get banners
- `GET /products.php?action=categories` - Get categories
- `GET /products.php?action=products` - Get products
- `GET /products.php?action=product&id=1` - Get single product
- `GET /products.php?action=search&q=search_term` - Search products

### Cart
- `GET /cart.php?action=cart` - Get cart items
- `POST /cart.php?action=add` - Add to cart
- `POST /cart.php?action=update` - Update cart item
- `DELETE /cart.php?action=remove&id=1` - Remove from cart
- `POST /cart.php?action=clear` - Clear cart

### Orders
- `POST /orders.php?action=place` - Place order
- `GET /orders.php?action=orders` - Get user orders
- `GET /orders.php?action=order&id=1` - Get single order
- `POST /orders.php?action=cancel` - Cancel order
- `GET /orders.php?action=track&id=1` - Track order

### Addresses
- `GET /addresses.php?action=addresses` - Get addresses
- `POST /addresses.php?action=add` - Add address
- `POST /addresses.php?action=update` - Update address
- `DELETE /addresses.php?action=delete&id=1` - Delete address
- `POST /addresses.php?action=set-default&id=1` - Set default address

### Auth
- `POST /auth.php?action=register` - Register user
- `POST /auth.php?action=login` - Login user
- `GET /auth.php?action=profile` - Get user profile
- `POST /auth.php?action=update-profile` - Update profile

## Request/Response Format

### Request
```json
POST /products.php?action=products
{
  "page": 1,
  "limit": 20,
  "category_id": 1
}
```

### Response
```json
{
  "success": true,
  "message": "Success",
  "timestamp": "2024-01-01 12:00:00",
  "data": {
    "products": [...],
    "pagination": {
      "current_page": 1,
      "per_page": 20,
      "total": 100,
      "total_pages": 5
    }
  }
}
```

## Sample Data

The database includes sample data:
- 2 sample users
- 5 product categories
- 10 sample products
- 3 promotional banners
- Sample addresses

## Testing

Test the API endpoints in your browser:

1. **Banners:** https://kwickbills.com/shop/api_core/products.php?action=banners
2. **Categories:** https://kwickbills.com/shop/api_core/products.php?action=categories
3. **Products:** https://kwickbills.com/shop/api_core/products.php?action=products

All should return JSON data with sample products.

## Troubleshooting

### Common Issues

1. **500 Internal Server Error**
   - Check database connection in `config.php`
   - Verify database exists and is accessible
   - Check PHP error logs

2. **404 Not Found**
   - Verify all files are uploaded correctly
   - Check `.htaccess` file is present
   - Verify folder structure

3. **Database Connection Failed**
   - Check database credentials
   - Verify MySQL service is running
   - Check user permissions

### Debug Mode

To enable debug mode, edit `config.php`:
```php
ini_set('display_errors', 1);
error_reporting(E_ALL);
```

## Security Notes

- Change JWT secret in `config.php`
- Use HTTPS in production
- Validate all inputs
- Implement proper user authentication
- Use prepared statements (already implemented)

## File Structure

```
api_core/
├── config.php          # Configuration and helpers
├── products.php        # Products, categories, banners
├── cart.php           # Shopping cart management
├── orders.php         # Order management
├── addresses.php      # Address management
├── auth.php           # User authentication
├── database.sql       # Database schema and sample data
├── .htaccess          # Apache configuration
└── README.md          # This file
```

## Next Steps

1. Upload files to server
2. Import database schema
3. Test API endpoints
4. Update Flutter app base URL
5. Test complete app functionality
