<?php
require_once 'config.php';

$action = $_GET['action'] ?? '';

try {
    $pdo = getDbConnection();
    
    switch ($action) {
        case 'register':
            registerUser($pdo);
            break;
            
        case 'login':
            loginUser($pdo);
            break;
            
        case 'profile':
            getUserProfile($pdo);
            break;
            
        case 'update-profile':
            updateUserProfile($pdo);
            break;
            
        default:
            handleError('Invalid action', 400);
    }
} catch (Exception $e) {
    handleError('Server error: ' . $e->getMessage(), 500);
}

function registerUser($pdo) {
    $data = getRequestData();
    validateRequired($data, ['phone', 'name']);
    
    $phone = $data['phone'];
    $name = $data['name'];
    $email = $data['email'] ?? '';
    
    // Check if user already exists
    $stmt = $pdo->prepare("SELECT * FROM users WHERE phone = :phone");
    $stmt->execute(['phone' => $phone]);
    $existingUser = $stmt->fetch();
    
    if ($existingUser) {
        handleError('User already exists with this phone number', 400);
    }
    
    // Create new user
    $stmt = $pdo->prepare("
        INSERT INTO users (name, email, phone, created_at, updated_at) 
        VALUES (:name, :email, :phone, NOW(), NOW())
    ");
    $stmt->execute([
        'name' => $name,
        'email' => $email,
        'phone' => $phone
    ]);
    
    $userId = $pdo->lastInsertId();
    
    // Get the created user
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = :id");
    $stmt->execute(['id' => $userId]);
    $user = $stmt->fetch();
    
    sendResponse(true, 'User registered successfully', $user);
}

function loginUser($pdo) {
    $data = getRequestData();
    validateRequired($data, ['phone']);
    
    $phone = $data['phone'];
    
    // Find user by phone
    $stmt = $pdo->prepare("SELECT * FROM users WHERE phone = :phone");
    $stmt->execute(['phone' => $phone]);
    $user = $stmt->fetch();
    
    if (!$user) {
        handleError('User not found', 404);
    }
    
    // Update last login
    $stmt = $pdo->prepare("UPDATE users SET last_login = NOW(), updated_at = NOW() WHERE id = :id");
    $stmt->execute(['id' => $user['id']]);
    
    sendResponse(true, 'Login successful', $user);
}

function getUserProfile($pdo) {
    $userId = getUserId();
    
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = :id");
    $stmt->execute(['id' => $userId]);
    $user = $stmt->fetch();
    
    if (!$user) {
        handleError('User not found', 404);
    }
    
    sendResponse(true, 'Profile retrieved successfully', $user);
}

function updateUserProfile($pdo) {
    $data = getRequestData();
    validateRequired($data, ['name']);
    
    $userId = getUserId();
    $name = $data['name'];
    $email = $data['email'] ?? '';
    
    $stmt = $pdo->prepare("
        UPDATE users SET 
            name = :name,
            email = :email,
            updated_at = NOW()
        WHERE id = :id
    ");
    $stmt->execute([
        'id' => $userId,
        'name' => $name,
        'email' => $email
    ]);
    
    // Get updated user
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = :id");
    $stmt->execute(['id' => $userId]);
    $user = $stmt->fetch();
    
    sendResponse(true, 'Profile updated successfully', $user);
}

function getUserId() {
    // Simple user ID for demo - in production, implement proper JWT authentication
    return 1;
}
?>
