<?php
// Core PHP API Configuration
// Simple configuration without external dependencies

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'ashwini_ecommerce');
define('DB_USER', 'root');
define('DB_PASS', '');

// API Configuration
define('API_BASE_URL', 'https://kwickbills.com/shop/api_core/');
define('JWT_SECRET', 'your_jwt_secret_key_here_change_this');

// CORS Headers
function setCorsHeaders() {
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
    header('Access-Control-Allow-Headers: Content-Type, Authorization');
    
    if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
        http_response_code(200);
        exit();
    }
}

// Database Connection
function getDbConnection() {
    try {
        $pdo = new PDO(
            "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
            DB_USER,
            DB_PASS,
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false
            ]
        );
        return $pdo;
    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode([
            'success' => false,
            'message' => 'Database connection failed',
            'error' => $e->getMessage()
        ]);
        exit();
    }
}

// Response Helper
function sendResponse($success = true, $message = 'Success', $data = null, $statusCode = 200) {
    http_response_code($statusCode);
    header('Content-Type: application/json');
    
    $response = [
        'success' => $success,
        'message' => $message,
        'timestamp' => date('Y-m-d H:i:s')
    ];
    
    if ($data !== null) {
        $response['data'] = $data;
    }
    
    echo json_encode($response);
    exit();
}

// Error Handler
function handleError($message, $statusCode = 500) {
    sendResponse(false, $message, null, $statusCode);
}

// Get Request Data
function getRequestData() {
    $input = file_get_contents('php://input');
    return json_decode($input, true) ?: [];
}

// Validate Required Fields
function validateRequired($data, $requiredFields) {
    $missing = [];
    foreach ($requiredFields as $field) {
        if (!isset($data[$field]) || empty($data[$field])) {
            $missing[] = $field;
        }
    }
    
    if (!empty($missing)) {
        handleError('Missing required fields: ' . implode(', ', $missing), 400);
    }
}

// Initialize
setCorsHeaders();
?>
